%---------------------------------------------------------------------------%
% vim: ft=mercury ts=4 sw=4 et wm=0 tw=0
%---------------------------------------------------------------------------%

% Test conversion of int32s to integers and integers to int32s.

:- module integer_int32_conv.
:- interface.

:- import_module io.

:- pred main(io::di, io::uo) is det.

%---------------------------------------------------------------------------%
%---------------------------------------------------------------------------%

:- implementation.

:- import_module int.
:- import_module list.
:- import_module integer.
:- import_module int32.

%---------------------------------------------------------------------------%

main(!IO) :-
    io.write_string("*** Testing int32 -> integer conversion ***\n\n", !IO),
    list.foldl(do_to_integer_test, test_int32s, !IO),
    io.nl(!IO),
    io.write_string("*** Testing integer -> int32 conversion ***\n\n", !IO),
    list.foldl(do_from_integer_test, test_integers, !IO).

:- pred do_to_integer_test(int32::in, io::di, io::uo) is det.

do_to_integer_test(U, !IO) :-
    Integer = integer.from_int32(U),
    io.write_string("int32 = ", !IO),
    io.write_int32(U, !IO),
    io.write_string(", integer = ", !IO),
    io.print(Integer, !IO),
    io.nl(!IO).

:- pred do_from_integer_test(integer::in, io::di, io::uo) is det.

do_from_integer_test(Integer, !IO) :-
    io.write_string("integer = ", !IO),
    io.print(Integer, !IO),
    io.write_string(", int32 = ", !IO),
    ( if integer.to_int32(Integer, U) then
        io.write_int32(U, !IO)
    else
        io.write_string("<<OUT-OF-RANGE>>", !IO)
    ),
    io.nl(!IO).

:- func test_int32s = list(int32).

test_int32s = [
    -2147483648i32,
    -32768i32,
    -128i32,
    -64i32,
    -32i32,
    -1i32,
    0i32,
    1i32,
    2i32,
    4i32,
    8i32,
    10i32,
    16i32,
    32i32,
    64i32,
    127i32,
    16383i32,  % i.e. integer.base - 1
    16384i32,  % i.e. integer.base
    16385i32,  % i.e. integer.base + 1,
    32767i32,
    2147483647i32
].

:- func test_integers = list(integer).

test_integers = [
    det_from_string("-9223372036854775808"),
    det_from_string("-4294967296"),
    det_from_string("-2147483649"),
    det_from_string("-2147483648"),
    det_from_string("-32768"),
    det_from_string("-2"),
    det_from_string("-1"),
    det_from_string("0"),
    det_from_string("1"),
    det_from_string("2"),
    det_from_string("16383"),
    det_from_string("16384"),
    det_from_string("16385"),
    det_from_string("32767"),
    det_from_string("1073741824"),
    det_from_string("2147483647"),
    det_from_string("2147483648"),
    det_from_string("4294967295"),
    det_from_string("4294967296"),
    det_from_string("4294967297"),
    det_from_string("9223372036854775808"),
    det_from_string("18446744073709551615"),
    det_from_string("18446744073709551616")
].
